/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.BloodMagicRecipe;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

public class RecipeARC
extends BloodMagicRecipe {
    public static final int MAX_RANDOM_OUTPUTS = 3;
    @Nonnull
    private final Ingredient input;
    private int inputSize = 1;
    @Nonnull
    private final Ingredient arc_tool;
    private final FluidStackIngredient inputFluid;
    @Nonnull
    protected final ItemStack output;
    protected final FluidStack outputFluid;
    private final boolean consumeIngredient;
    protected final List<Pair<ItemStack, Pair<Double, Double>>> addedItems;

    public RecipeARC(ResourceLocation id, Ingredient input, Ingredient arc_tool, FluidStackIngredient inputFluid, ItemStack output, FluidStack outputFluid, boolean consumeIngredient) {
        this(id, input, 1, arc_tool, inputFluid, output, new ArrayList<Pair<ItemStack, Pair<Double, Double>>>(), outputFluid, consumeIngredient);
    }

    public RecipeARC(ResourceLocation id, Ingredient input, int inputSize, Ingredient arc_tool, FluidStackIngredient inputFluid, ItemStack output, List<Pair<ItemStack, Pair<Double, Double>>> addedItems, FluidStack outputFluid, boolean consumeIngredient) {
        super(id);
        this.input = input;
        this.arc_tool = arc_tool;
        this.inputFluid = inputFluid;
        this.output = output;
        this.addedItems = addedItems;
        this.outputFluid = outputFluid;
        this.consumeIngredient = consumeIngredient;
        this.inputSize = inputSize;
    }

    public RecipeARC addRandomOutput(ItemStack stack, double base, double secondary) {
        if (this.addedItems.size() >= 3) {
            return this;
        }
        this.addedItems.add((Pair<ItemStack, Pair<Double, Double>>)Pair.of((Object)stack, (Object)Pair.of((Object)base, (Object)secondary)));
        return this;
    }

    public RecipeARC addRandomOutput(ItemStack stack, double secondary) {
        return this.addRandomOutput(stack, 0.0, secondary);
    }

    @Nonnull
    public final Ingredient getInput() {
        return this.input;
    }

    @Nonnull
    public final Ingredient getTool() {
        return this.arc_tool;
    }

    public final FluidStackIngredient getFluidIngredient() {
        return this.inputFluid;
    }

    public final FluidStack getFluidOutput() {
        return this.outputFluid;
    }

    public final NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.getInput());
        list.add((Object)this.getTool());
        return list;
    }

    public int getRequiredInputCount() {
        return this.inputSize;
    }

    public List<ItemStack> getAllListedOutputs() {
        return this.getAllListedOutputs(ItemStack.f_41583_, ItemStack.f_41583_);
    }

    public List<ItemStack> getAllListedOutputs(ItemStack inputStack, ItemStack toolStack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.output.m_41777_());
        for (Pair<ItemStack, Pair<Double, Double>> pair : this.addedItems) {
            list.add(((ItemStack)pair.getLeft()).m_41777_());
        }
        return list;
    }

    public List<ItemStack> getAllOutputs(Random rand, ItemStack inputStack, ItemStack toolStack, double secondaryBonus) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.output.m_41777_());
        for (Pair<ItemStack, Pair<Double, Double>> pair : this.addedItems) {
            Pair bonus = (Pair)pair.getRight();
            if (!(rand.nextDouble() < (Double)bonus.getLeft() + secondaryBonus * (Double)bonus.getRight())) continue;
            list.add(((ItemStack)pair.getLeft()).m_41777_());
        }
        return list;
    }

    public List<Pair<Double, Double>> getAllOutputChances() {
        ArrayList<Pair<Double, Double>> list = new ArrayList<Pair<Double, Double>>();
        for (Pair<ItemStack, Pair<Double, Double>> entry : this.addedItems) {
            list.add((Pair<Double, Double>)((Pair)entry.getRight()));
        }
        return list;
    }

    public boolean getConsumeIngredient() {
        return this.consumeIngredient;
    }

    public boolean breakTool() {
        return true;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.writeInt(this.inputSize);
        this.arc_tool.m_43923_(buffer);
        buffer.m_130055_(this.output);
        buffer.writeInt(this.addedItems.size());
        for (Pair<ItemStack, Pair<Double, Double>> pair : this.addedItems) {
            buffer.m_130055_((ItemStack)pair.getLeft());
            buffer.writeDouble(((Double)((Pair)pair.getValue()).getKey()).doubleValue());
            buffer.writeDouble(((Double)((Pair)pair.getValue()).getValue()).doubleValue());
        }
        buffer.writeBoolean(this.inputFluid != null);
        if (this.inputFluid != null) {
            this.inputFluid.write(buffer);
        }
        buffer.writeBoolean(this.outputFluid != null);
        if (this.outputFluid != null) {
            this.outputFluid.writeToPacket(buffer);
        }
        buffer.writeBoolean(this.consumeIngredient);
    }

    public RecipeSerializer<? extends RecipeARC> m_7707_() {
        return BloodMagicRecipeSerializers.ARC.getRecipeSerializer();
    }

    public RecipeType<RecipeARC> m_6671_() {
        return (RecipeType)BloodMagicRecipeType.ARC.get();
    }
}

